## What is this ?

This is a [MuseScore](https://handbook.musescore.org/) [plugin](https://musescore.org/en/plugins) which adds annotations to the current score showing the accordion buttons corresponding to each note. The plugin can also be used to display the corresponding holes for a harmonica, or similar instrument.

The distribution includes tables for a few types of accordion and harmonicas, but these can easily be extended to support other instruments - see the section below on "Adding support for different instruments".

Where there are multiple ways of playing the same note or chord, the plugin can display all of the possibilities or just pick an arbitrary one. If all of the possibilities are shown, the score can be manually edited to remove the unwanted ones.

The dialog supports a lot of customisation, including the various symbols used to indicate the different actions as well as the font style. However, a number of Presets are provided for several common styles avoiding the need to set all of the detailed options.

Paul Anderson <<paul.musescore@nine3.org>>

## Installation

Current and previous versions are available for download from the [website](https://www.nine3.org/downloads/home/accordion.html).

Unpack the zip file. Move the `AccordionButtons` folder to MuseScore's plugins folder. This is configurable at `Preferences:General:Folders`. The default directories are:

- `Windows: C:\Users\%USERNAME%\Documents\MuseScore4\Plugins`
- `macOS: ~/Documents/MuseScore4/Plugins`
- `Linux: ~/Documents/MuseScore4/Plugins`

Click ``Home: Plugins or Plugins: Manage plugins...`` and `Enable` the plugin.

To update to a new version, simply replace the `AccordionButtons` folder with the new one (you may need to restart Musescore).

## Options

The dialog box supports a number of options:

- `Instrument`: Select the required instrument. If your instrument is not in the list, you may be able to add add it by creating your own table entry (see below). Some instruments will show an information button [`?`] when they are selected. Clicking on this will display more details about the instrument. 

- `Variant`: Some instruments are available in different "variants" - for example, the Blues Harp is available in several different keys. This option allows the variant to be selected. The option will be disabled (`N/A`) if it is not appropriate for the selected instrument.

- `Label`: If this box is checked, the plugin will add a label at the start of the score showing the instrument for which it has been annotated.

- `Preset`: This automatically sets the detailed options to match the chosen style. Some presets will show an information button [`?`] when they are selected. Clicking on this will display more details. 

- `8ve`: The annotations are computed as if the piece had been transposed by the selected number of octaves. This may make the piece playable if it is outside the normal range of the instrument. `Concert` means that no transposition is selected.

- `Font`: The font for the annotations. You can change this to any available font by clicking on the button (but see below).

- `Font size`: The font size for the annotation symbols.

- `Font style`: The font style for the annotation symbols (bold, italic etc.).

- `Pad`: If this box is checked, some extra padding will be added around the annotations to make them more readable. Unchecking the box will create a more compressed format which may avoid additional line breaks.

The following section provides a lot of control over the way in which the annotations are displayed. Choosing a preset style will automatically set these options appropriately and no further changes will be needed. However, the options can be individually tweaked to customise the appearance.

Generally, an annotation consists of a number representing a button (or hole), together with a symbol indicating push/pull (or blow/suck) and an optional symbol indicating the row of the corresponding button (or hole). In each case, the dialog allows you to specify a symbol to appear before or after the number (or both).

The buttons with arrows allow you to change whether the row symbols appear inside or outside the push/pull symbols.

The underscore button indicates that the note should be underlined, and the button with a down arrow indicates that the annotation should appear lower on the line.

Special symbols for up/down arrows or a newline can be entered using the corresponding keys. If a space is entered, it appears as a special symbol to show that the symbol is a space, rather than "nothing". Use the delete key to clear a symbol completely.

- `Push`: The characters to use in the score to represent a push (or blow) note.

- `Pull`: The characters to use in the score to represent a pull (or suck) note. 

- `Row`: The characters to use in the score to represent an alternative button (or hole) "row".

- `Chord`: If the score contains multiple simultaneous notes, the annotations will be enclosed between the two outer symbols and separated by the inner symbol.

- `Chord Style`: If the score includes a bass stave, and this is supported by the selected instrument, then the plugin will add appropriate chord symbols and bass notes. Two styles are available for these symbols: the `Default` style distinguishes between extensions and inversions and uses a typical jazz notation. The `Simple` style provides a simpler notation suitable for most accordions.

- `Alternatives`: This determines whether all of the alternative ways of playing a particular note/chord are shown, or whether an arbitrary one is picked. If the alternatives are shown, this option provides few choices about how they are displayed.
Normally, the alternatives are added to the score as separate elements which can be deleted and moved independently. The `Combined` option displays all of the alternatives on multiple lines of a single element. This may be easier to edit, but it is only possible when all the alternatives have the same style and offset.

- `Reset`: This button will remove all annotations which have been added to the score by the plugin.

### Fonts

The plugin allows any font which is available on the current system to be used for the annotations. *However* many of the fonts shown in the list will not be available on all other systems - the available fonts depend on the operating system (Microsoft/Apple etc.) as well as any additional fonts which have been installed.

If you plan to share the document with others, you should take care to use a font which you know will be available to the recipient. If the font is not available, Musescore will substitute a different font, so it will still be readable although the layout may be changed. Choosing `Lyric Font` will use the default Musescore lyric font which will be available on all systems which have Musescore installed.

The AccordionButton plugin uses `Arial Narrow` as the default font - this is pre-installed on most systems and is a clear narrow font which helps to prevent the annotations spreading out the score. The `Magnus` style uses the extra-condensed font `Gill Sans MT Ext Condensed Bold` to reduce the spreading when using a larger font size. This is not installed by default on most systems, but is freely available from [FreeFontDownload](https://www.freefontdownload.org/en/gill-sans-mt-extended-condensed-bold.font).

If you export a PDF document, Musescore will embed the necessary fonts, so this should render correctly on all other systems, even if they don't have the necessary fonts installed.

## Adding support for different languages

Unfortunately, the Musescore plugin API does not support the standard Qt method of specifying strings to localize the interface. However, the plugin provides a simple alternative, and a French translation is included in the distribution.

To add support for a new language, take a copy of the `ExampleTranslations.js` file and copy it to the `CustomTranslations.js` file. Edit `CustomTranslations.js` to:

- replace the language code (`"en"`) with the appropriate locale. For example, `es` or `es_MX` (see [here](https://saimana.com/list-of-country-locale-code/
) for the list of codes).

- replace the translation of each string with the required text. For example:
  ```
  "Default": "Por Defecto",
  ```

If you create a translation file for a new language, please let me know and I will be happy to include it in the distribution.

*Always keep a separate copy of any translation file that you create* - you will need to re-install it whenever you upgrade to a new version of the plugin.

## Adding support for different instruments

Many different types and variations of accordions are available. The plugin is very flexible and it can be customised to support most of these simply by creating an appropriate "instrument table". This table describes the notes that the instrument can play and the corresponding buttons, etc.

Creating a new instrument table is a simple process and shouldn't require any special skills - although you will need to follow the instructions carefully and pay attention to the punctuation, especially if you are not used to writing code. If you would like to create a new table, but are having difficulty, please get in touch and I may be able to help.

If you do create a table for a new instrument, please let me know and I will be happy to include it in the distribution.

*Always keep a separate copy of any instrument file that you create* - you will need to re-install it whenever you upgrade to a new version of the plugin.

### Creating an instrument table

To add a table for a new instrument, you will need edit the file `CustomInstruments.js` (using any text editor such as Notepad or Textedit). The default file doesn't include any instruments:

```
var instruments = [
];
```

To add a new instrument, edit the file so it looks something like this:

```
var instruments = [

  {
    name: "My Instrument",
  },

];
```
You can use whatever name you like in place of `My Instrument`, but the other content (including the punctuation) is critical. The layout (spacing) is less critical, but it makes the code more readable if you replicate the example.

If you would like the instrument name to be translatable into different languages, include the translation in the appropriate language file (see above) and use the `xsTr` function:
```
  name: xsTr("My Instrument"),
```

If your instrument comes in several different keys, you can add these after the instrument name. For example:

```
name: "21 Button Accordion",
keys: [
  { name: "B/C" },
  { name: "C♯/D", transpose: 2 },
],
```
This accordion comes in two versions (`B/C`and `C♯/D`). The tables which follow refer to the `B/C` version (no transposition). The `C♯/D` version will be generated automatically by transposing the tables by 2 semitones. You do not need the `keys` section at all if your instrument just comes in one key.

The key names can be made translatable in the same way as the instrument name:
```
  { name: xsTr("C♯/D"), transpose: 2 },
```

If you save the file and restart Musescore at this stage, your instrument should appear in the menu - although selecting it and clicking the `OK` button won't do anything yet because we haven't defined any of the notes/chords. If you have multiple keys, they should show in the key selector.

### Staves

The plugin supports different annotations for different "staves". The first stave is the `treble` stave (e.g. the right hand), and the second stave (if present) is the `bass` stave (e.g. the left hand). If this doesn't make sense for your instrument (e.g. a harmonica), you can just define a single `default` stave.

The table needs to include a section for each required stave. For example:
```
var instruments = [

  {
    name: "My Instrument",
    staves: {
      treble: {
        ...
      },
      bass: {
        ...
      },
    },
  },

];
```
Where the `...` contains the description of the annotations for the corresponding stave (see below).

Two different kinds of annotations are supported: (a) where individual notes are annotated with the buttons required to produce them, and (b) where single notes or chords are annotated with the name of the note or chord. Typically, (a) would be used for the right hand (treble stave) of a button accordion for example, and (b) would be used for the left hand.

### Note annotations (a)

If individual notes are to be annotated with the corresponding buttons, then the table section should look something like this:

```
treble: {
  min: 51,
  max: 90,
  notes: [
    "+1^",      // Eb (51)
    "+1",       // E
    "?",        // F
    ...
    "+6^|-6",   // B
    ...
  ],
},
```

The `min` and `max` define the lowest and highest playable note. The numbers are the Musescore pitch numbers which are defined in the [Musescore Pitch Values](https://musescore.github.io/MuseScore_PluginAPI_Docs/plugins/html/pitch.html) page (51 is E♭ and 90 is F♯).

The notes section must contain one line for each of the notes in the instrument range (51..90). The `//` and following text is ignored by the plugin, but it makes the file more readable if we add a comment here with the corresponding note name.

The description of each note is enclosed in quotes and contains:

- A `+` or `-` symbol indicating a push (blow) or a pull (suck).
- A button (or hole) number.
- Optionally, one or more `^` symbols indicating the "row".
- Optionally, a `|` symbol followed by an alternative way of playing the same note.

If a note in the range is not playable, then it can be specified as `?`. 

If more than one alternative is given for a note, the first one will be the one displayed if the user opts not to see all of the possibilities.

Notice that the symbols used in the table (`+/-/|`) are only used to define the attributes of the annotation to the plugin. The way in which these appear on the score is determined by the settings which the user selects from the dialog.

### Chord/Bass annotations (b)

The simplest way of adding chord and bass note annotations is to allow the plugin to automatically deduce the chord names from the notes:

```
bass: {
  auto: true,
},
```
Basic triads and 4-note chords (in any inversion/octave) will be annotated with chord symbols, and single notes will be annotated with the note name.

It is also possible to specify chords and their corresponding annotation exactly:
```
bass: {
  chords: {
    "72,76,79": "+Cma",
    ...
  },
},
```
The chord with the notes `72,76,70` (CEG in that specific octave) will be annotated with a "push" symbol and the text `Cma`.

If `auto` and `chords` are both present, the explicit chord will be used if given, otherwise the symbol will be generated automatically.

### Instrument "variants"

The `keys` section of the table supports instruments which come in several different keys. In some cases however, there are variations of the same instrument which are not simply the same set of notes raised or lowered by a fixed interval - they may have slightly different button arrangements or ranges, for example. The plugin caters for these more significant variations by allowing different "stave" sections to be specified for different "variants" of the instrument. For example:

```
{
  name: "Instrument with variants",
  keys: [
    { name: "C" },
    { name: "D", transpose: 2 },
    { name: "E", staves: "X" },
    { name: "F", transpose: 1, staves: "X" },
  ],
  staves: {
    ...
  },
  staves_X: {
    ...
  },
}

```
In this case, the C and D variants of the instrument will use the default `staves` tables (with the D instrument transposed by two semitones), and the E and F versions of the instrument will use the `staves_X` tables (with the F instrument transposed by one semitone). There can be any number of variants, and the names (`X` in this case) may be any string of letters and numbers.

### Description, author and identifiers

It is useful to include a description of the instrument, and optionally the name of the table author, which the user will then be able to see by clicking the `?` button next to the instrument name. The description should be in HTML - as well as styling, this supports web links to a full description of the instrument. For example:
```
{
  name: "Instrument with description",
  info: `
    Here is a description of this instrument.<br/>
    You can find more details <a href="https://some-link">here</a>.
`,
  author: "Paul Anderson",
  ...

```
Notice the use of the backticks to specify the multi-line value.

Both the overall table and the records for the keys (if any) may include an optional `id`. This is a unique identifier which can be used by the presets to reference a specific instrument/key combination:
```
  id: "my-instrument23",
```
This does not need to be present unless the instrumeny/key if used in a preset.


## An example instrument table

```

{
  name: xsTr("21 Button Accordion"),
  id: "21button"
  author: "Paul Anderson"
  info: `
    See <a href="https://forum.melodeon.net/files/site/BC21tradbass.gif">here</a>
    and <a href="https://forum.melodeon.net/files/site/CD21tradbass.gif">here</a>.
`,
  keys: [
    { name: xsTr("B/C") },
    { name: xsTr("C♯/D"), transpose: 2 },
  ],
  staves: {
    treble: {
      min: 51,
      max: 90,
      notes: [
        "+1^",      // Eb (51)
        "+1",       // E
        "?",        // F
        "+2^",      // F#
        "+2",       // G
        "-1^",      // G#
        "-1",       // A
        "-2",       // Bb
        "+3^|-2",   // B
        "+3",       // (middle) C
        "-3^",      // C#
        "-3",       // D
        "+4^",      // Eb
        "+4|-4^",   // E
        "-4",       // F
        "+5^",      // F#
        "+5",       // G
        "-5^",      // G#
        "-5",       // A
        "-6^",      // Bb
        "+6^|-6",   // B
        "+6",       // C
        "-7^",      // C#
        "-7",       // D
        "+7^",      // Eb
        "+7|-8^",   // E
        "-8",       // F
        "+8^",      // F#
        "+8",       // G
        "-9^",      // G#
        "-9",       // A
        "-10^",     // Bb
        "+9^|-10",  // B
        "+9",       // C
        "-11^",     // C#
        "?",        // D
        "+10^",     // Eb
        "+10",      // E
        "?",        // F
        "+11",      // F# (90)
      ],
    },
    bass: {
      auto: true,
    },
  },
}
```

## Acknowledgements

Thanks to Marc Duval, Daniel Meyer and Bill Wallace for their instrument tables, feedback and lots of general advice on accordions. And to ChatGPT for some interesting discussions on fonts and localisation. 

Thanks also to everyone who has made their code freely available. I wouldn't have been able to write this without the many examples that have been used as inspiration or directly copied. In particular, the basic Musescore interface is based on these plugins:

- [Jianpu numbers](https://musescore.org/en/project/add-jianpu-numbers-text-lyrics-wuxianpu-jianpu)
- [Solfa names](https://musescore.org/node/345087)
- [Mirabilos plugins](https://github.com/mirabilos/mscore-plugins)

<hr>

_version 2.3, published at 1:33pm on Tuesday 25th November 2025_
